// DemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Demo.h"
#include "DemoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDemoDlg dialog

CDemoDlg::CDemoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDemoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDemoDlg)
	m_innerbevelbtn = 0;
	m_orientationbtn = 0;
	m_outerbevelbtn = 1;
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDemoDlg)
	DDX_Control(pDX, IDC_SLIDER4, m_outerbevelwidth);
	DDX_Control(pDX, IDC_SLIDER3, m_innerbevelwidth);
	DDX_Control(pDX, IDC_SLIDER2, m_borderwidth);
	DDX_Control(pDX, IDC_SLIDER1, m_pos);
	DDX_Control(pDX, IDC_SLIDER5, m_tickmarks);
	DDX_Control(pDX, 1008, m_meter);
	DDX_Radio(pDX, IDC_RADIO8, m_innerbevelbtn);
	DDX_Radio(pDX, IDC_RADIO5, m_orientationbtn);
	DDX_Radio(pDX, IDC_RADIO3, m_outerbevelbtn);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDemoDlg, CDialog)
	//{{AFX_MSG_MAP(CDemoDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_RADIO8, OnRadio8)
	ON_BN_CLICKED(IDC_RADIO7, OnRadio7)
	ON_BN_CLICKED(IDC_RADIO6, OnRadio6)
	ON_BN_CLICKED(IDC_RADIO5, OnRadio5)
	ON_BN_CLICKED(IDC_RADIO4, OnRadio4)
	ON_BN_CLICKED(IDC_RADIO3, OnRadio3)
	ON_BN_CLICKED(IDC_RADIO2, OnRadio2)
	ON_BN_CLICKED(IDC_RADIO1, OnRadio1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemoDlg message handlers

BOOL CDemoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_outerbevelwidth.SetRange(0, 10, TRUE);
	m_innerbevelwidth.SetRange(0, 10, TRUE);
	m_borderwidth.SetRange(0, 30, TRUE);
	m_pos.SetRange(0, 100, TRUE);
	m_tickmarks.SetRange(3, 40, TRUE);

	m_outerbevelwidth.SetPageSize(1);
	m_innerbevelwidth.SetPageSize(1);
	m_borderwidth.SetPageSize(1);
	m_pos.SetPageSize(5);
	m_tickmarks.SetPageSize(5);

	m_outerbevelwidth.SetPos(2);
	m_innerbevelwidth.SetPos(2);
	m_borderwidth.SetPos(3);
	m_pos.SetPos(50);
	m_tickmarks.SetPos(5);

	//Use this to convert between dialog units in the resource
	//editor and client coordinates in the dialog for MoveWindow calls
	CRect rect;
	m_meter.GetWindowRect(&rect);
	ScreenToClient(&rect);
	TRACE("left %d, Top %d, width %d, height %d\n", rect.left, rect.top,
		rect.Width(), rect.Height());
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDemoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CDemoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BEGIN_EVENTSINK_MAP(CDemoDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CDemoDlg)
	ON_EVENT(CDemoDlg, 1008, 1 /* Alarm */, OnAlarm, VTS_PI2)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CDemoDlg::OnAlarm(short FAR* Alarm) 
{
static BOOL bInAlarm = FALSE;

	if (!bInAlarm)
	{
		bInAlarm = TRUE;
		if (*Alarm == 1)
		{
			MessageBox("Low Alarm Hit!");
		}
		else
		{
			MessageBox("High Alarm Hit!");
		}

		bInAlarm = FALSE;
	}
}

void CDemoDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
		if (SB_ENDSCROLL == nSBCode)
	{
		if (&m_outerbevelwidth == (CSliderCtrl *)pScrollBar)
		{
			m_meter.SetOuterBevelWidth(((CSliderCtrl *)pScrollBar)->GetPos());
		}
		else if (&m_innerbevelwidth == (CSliderCtrl *)pScrollBar)
		{
			m_meter.SetInnerBevelWidth(((CSliderCtrl *)pScrollBar)->GetPos());
		}
		else if (&m_borderwidth == (CSliderCtrl *)pScrollBar)
		{
			m_meter.SetBorderWidth(((CSliderCtrl *)pScrollBar)->GetPos());
		}
		else if (&m_pos == (CSliderCtrl *)pScrollBar)
		{
			m_meter.SetPos(((CSliderCtrl *)pScrollBar)->GetPos());
		}
		else
		{
			m_meter.SetTickMarks(((CSliderCtrl *)pScrollBar)->GetPos());
		}
	}
	
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CDemoDlg::OnRadio8() 
{
	UpdateData();
	m_meter.SetInnerBevel(m_innerbevelbtn);
}

void CDemoDlg::OnRadio7() 
{
	OnRadio8();
}

void CDemoDlg::OnRadio6() 
{
	OnRadio8();	
}

void CDemoDlg::OnRadio5() 
{
	UpdateData();
	m_meter.SetOrientation(m_orientationbtn);
	m_orientationbtn?
		m_meter.MoveWindow(86, 15, 60, 165):
		m_meter.MoveWindow(17, 81, 208, 44);
		
}

void CDemoDlg::OnRadio4() 
{
	OnRadio5();
}

void CDemoDlg::OnRadio3() 
{
	UpdateData();
	m_meter.SetOuterBevel(m_outerbevelbtn);
}

void CDemoDlg::OnRadio2() 
{
	OnRadio3();
}

void CDemoDlg::OnRadio1() 
{
	OnRadio3();
}
